Attribute VB_Name = "RegMap"
'// ------------------------------------------------------------------------------------- //
'// Modulo para cargar Mapas de Bits en memoria y funcion de lectura de pixeles para usar //
'// como Mapas de Durezas.                                                                //
'//                                                                                       //
'// [EX3] - Jos Miguel Snchez Fernndez                                                 //
'// ------------------------------------------------------------------------------------- //

Option Explicit

'// Declaraciones del API de Windows //

'// CreateCompatibleDC() - Crea un Contexto de Dispositivo (DC) compatible con el dispositivo especificado:
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long

' // DeleteDC() - Borra el Contexto de Dispositivo especificado:
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

'// SelectObject() - Selecciona un objeto dentro del contexto de dispositivo especificado. El nuevo objeto sustituye el objeto anterior del mismo tipo:
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long

'// DeleteObject() - Libera todos los recursos del sistema asociados al objeto. Despues el objeto es eliminado, el identificador especificado deja de ser valido:
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long

'// GDIGetPixel() alias GetPixel() - Devuelve los canales RGB del color del pixel especificado por las coordenadas:
Private Declare Function GDIGetPixel Lib "gdi32" Alias "GetPixel" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long) As Long

'// Estructura que representa un mapa de bits en memoria:
Private Type BMP_Handle
    hdc As Long '// Idenficicador (handle) del Contexto de Dispositivo (hDC)
    Surface As Picture '// Superficie definida por el objeto Picture para almacenar los mapas de bits.

End Type

'// Array que almacenara los mapas de bits:
Public BitMap() As BMP_Handle

'// Carga un archivo de imagen BMP, DIB, GIF, JPEG, WMF mediante el objeto Picture de la libreria del Visual Basic 6.0: (Antencion: Objeto Picture, no confundir con Control PictureBox)
Public Function Load_BitMap(FileName As String) As Long
On Error GoTo ErrOut

Dim i As Long '// Ubicacion del mapa de bits en el array.

i = Get_FreeHandle '// Obtenemos una ubicacion valida (o vacia si la hubiese) en el array para almacenar el mapa de bits.

With BitMap(i)
    .hdc = CreateCompatibleDC(0) '// Creamos un DC compatible con el dispositivo por defecto.
    Set .Surface = LoadPicture(FileName) '// Cargamos la imagen en la superficie mediante la funcion LoadPicture() de la libreria de Visual Basic 6.0

    Call SelectObject(.hdc, .Surface.Handle) '// Creamos un nuevo objeto con la informacion del mapa de bits.

    Load_BitMap = i '// Devolvemos la ubicacion del mapa de bits en el array a modo de indentificador con el que se accedera despues para leer los pixeles y para borrar la imagen de la memoria.

End With

ErrOut:
    
End Function

'// Descarga un mapa de bits de la memoria:
Public Sub Unload_BitMap(Handle As Long)
On Error GoTo ErrOut

    '// Si el identificador corresponde con el ultimo elemento del array...
    If Handle = UBound(BitMap) Then
        If Handle = 0 Then '//Si el identificador es el primer elemento del array...
            Erase BitMap '// Eliminamos por completo el array liberando la memoria ocupada.

        Else '// Si se trata del ultimo elemento del array entonces redimensionamos el array con un elemento menos liberando la memoria ocupada por el:
            ReDim Preserve BitMap(UBound(BitMap) - 1) As BMP_Handle

        End If

    Else '// Si se trata de un elemento intermedio del array liberamos su memoria pero conservamos su espacio para ser usado en la proxima carga de Load_BitMap():

        With BitMap(Handle)
            Call DeleteObject(.Surface.Handle) '// Eliminamos el objeto liberando su memoria.
            Call DeleteDC(.hdc) '// Eliminamos el Contexto de Dispostivo.
            Set .Surface = Nothing '// Liberamos la superficie.

        End With


    End If

ErrOut:

End Sub

'// Lee el pixel de un mapa de bits cargado en memoria:
Public Function GetPixel(Handle As Long, X As Long, Y As Long) As Long
GetPixel = GDIGetPixel(BitMap(Handle).hdc, X, Y)

End Function


'// Lee el hdc de un mapa de bits cargado en memoria:
Public Function GetDC(Handle As Long) As Long
GetDC = BitMap(Handle).hdc
End Function

'// Devuelve una ubicacion nueva o vacia en el array para almacenar un nuevo mapa de bits en memoria:
Private Function Get_FreeHandle() As Long
On Error Resume Next

Dim i As Long, j As Long

i = UBound(BitMap) '// Obtenemos la cantidad de elemenos del array.

If Err.Number = 9 Then '// Si el array no contiene elementos...
    ReDim BitMap(0) As BMP_Handle '// Redimensionamos el array a 0 creando un elemento vacio.

    Get_FreeHandle = 0 '// Devolvemos la posicion del elemento que seria 0 al ser el primero.

Else '// Si el array contenia elementos buscamos el primer elemento vacio que exista y se recicla:
    For j = 0 To i
        If BitMap(j).Surface Is Nothing Then '// Si la superficie esta liberada hemos encontrado un elemento vacio.
            Get_FreeHandle = j '// Devolvemos la posicion del elemento.
            Exit For '// Salimos del bucle.

        End If

    Next j

    '// Si no existia ningun elemento vacio se aade uno nuevo al array:
    ReDim Preserve BitMap(i + 1) As BMP_Handle '// Redimensionamos el array incrementando su indice:
    Get_FreeHandle = i + 1 '// Devolvemos la posicion del nuevo elemento.

End If

End Function
